/*
 * Decompiled with CFR 0.152.
 */
package jaredbgreat.dldungeons.pieces;

import jaredbgreat.dldungeons.planner.Dungeon;
import jaredbgreat.dldungeons.rooms.Room;
import jaredbgreat.dldungeons.themes.ThemeFlags;
import jaredbgreat.dldungeons.themes.ThemeType;

public final class Rectangle {
    private final float xdim;
    private final float zdim;
    private final float xcoord;
    private final float zcoord;
    public static final Rectangle simple = new Rectangle(1.0f, 1.0f, 0.0f, 0.0f);
    public static final Rectangle lback000 = new Rectangle(0.5f, 1.0f, -0.25f, 0.0f);
    public static final Rectangle lbottom000 = new Rectangle(0.5f, 0.5f, 0.25f, -0.25f);
    public static final Rectangle lback090 = new Rectangle(1.0f, 0.5f, 0.0f, -0.25f);
    public static final Rectangle lbottom090 = new Rectangle(0.5f, 0.5f, 0.25f, 0.25f);
    public static final Rectangle lback270 = new Rectangle(0.5f, 1.0f, 0.25f, 0.0f);
    public static final Rectangle lbottom270 = new Rectangle(0.5f, 0.5f, -0.25f, 0.25f);
    public static final Rectangle lback180 = new Rectangle(1.0f, 0.5f, 0.0f, -0.25f);
    public static final Rectangle lbottom180 = new Rectangle(0.5f, 0.5f, 0.25f, 0.25f);
    public static final Rectangle oleft = new Rectangle(0.33333334f, 1.0f, -0.33333334f, 0.0f);
    public static final Rectangle oright = new Rectangle(0.33333334f, 1.0f, 0.33333334f, 0.0f);
    public static final Rectangle obottom = new Rectangle(0.33333334f, 0.33333334f, 0.0f, -0.33333334f);
    public static final Rectangle otop = new Rectangle(0.33333334f, 0.33333334f, 0.0f, 0.33333334f);
    public static final Rectangle ttop000 = new Rectangle(1.0f, 0.33333334f, 0.0f, 0.33333334f);
    public static final Rectangle tbottom000 = new Rectangle(0.33333334f, 0.6666667f, 0.0f, -0.16666667f);
    public static final Rectangle ttop090 = new Rectangle(0.33333334f, 1.0f, -0.33333334f, 0.0f);
    public static final Rectangle tbottom090 = new Rectangle(0.6666667f, 0.33333334f, 0.16666667f, 0.0f);
    public static final Rectangle ttop180 = new Rectangle(1.0f, 0.33333334f, 0.0f, -0.33333334f);
    public static final Rectangle tbottom180 = new Rectangle(0.33333334f, 0.6666667f, 0.0f, 0.16666667f);
    public static final Rectangle ttop270 = new Rectangle(0.33333334f, 1.0f, 0.33333334f, 0.0f);
    public static final Rectangle tbottom270 = new Rectangle(0.6666667f, 0.33333334f, -0.16666667f, 0.0f);
    public static final Rectangle eback000 = new Rectangle(0.33333334f, 1.0f, -0.33333334f, 0.0f);
    public static final Rectangle etop000 = new Rectangle(0.6666667f, 0.2f, 0.16666667f, 0.4f);
    public static final Rectangle emiddle000 = new Rectangle(0.6666667f, 0.2f, 0.16666667f, 0.0f);
    public static final Rectangle ebottom000 = new Rectangle(0.6666667f, 0.2f, 0.16666667f, -0.4f);
    public static final Rectangle eback090 = new Rectangle(1.0f, 0.33333334f, 0.0f, -0.33333334f);
    public static final Rectangle etop090 = new Rectangle(0.2f, 0.6666667f, -0.4f, 0.16666667f);
    public static final Rectangle emiddle090 = new Rectangle(0.2f, 0.6666667f, 0.0f, 0.16666667f);
    public static final Rectangle ebottom090 = new Rectangle(0.2f, 0.6666667f, 0.4f, 0.16666667f);
    public static final Rectangle eback180 = new Rectangle(0.33333334f, 1.0f, 0.33333334f, 0.0f);
    public static final Rectangle etop180 = new Rectangle(0.6666667f, 0.2f, -0.16666667f, 0.4f);
    public static final Rectangle emiddle180 = new Rectangle(0.6666667f, 0.2f, -0.16666667f, 0.0f);
    public static final Rectangle ebottom180 = new Rectangle(0.6666667f, 0.2f, -0.16666667f, -0.4f);
    public static final Rectangle eback270 = new Rectangle(1.0f, 0.33333334f, 0.0f, 0.33333334f);
    public static final Rectangle etop270 = new Rectangle(0.2f, 0.6666667f, 0.4f, -0.16666667f);
    public static final Rectangle emiddle270 = new Rectangle(0.2f, 0.6666667f, 0.0f, -0.16666667f);
    public static final Rectangle ebottom270 = new Rectangle(0.2f, 0.6666667f, -0.4f, -0.16666667f);
    public static final Rectangle itop = new Rectangle(1.0f, 0.33333334f, 0.0f, 0.33333334f);
    public static final Rectangle imiddle = new Rectangle(0.33333334f, 0.33333334f, 0.0f, 0.0f);
    public static final Rectangle ibottom = new Rectangle(1.0f, 0.33333334f, 0.0f, -0.33333334f);
    public static final Rectangle iright = new Rectangle(0.33333334f, 1.0f, 0.33333334f, 0.0f);
    public static final Rectangle ileft = new Rectangle(0.33333334f, 1.0f, -0.33333334f, 0.0f);
    public static final Rectangle crosstop = new Rectangle(0.33333334f, 0.33333334f, 0.0f, 0.33333334f);
    public static final Rectangle crossmiddle = new Rectangle(1.0f, 0.33333334f, 0.0f, 0.0f);
    public static final Rectangle crossbottom = new Rectangle(0.33333334f, 0.33333334f, 0.0f, -0.33333334f);
    public static final Rectangle uleft000 = new Rectangle(0.33333334f, 0.6666667f, -0.33333334f, 0.16666667f);
    public static final Rectangle uright000 = new Rectangle(0.33333334f, 0.6666667f, 0.33333334f, 0.16666667f);
    public static final Rectangle ubottom000 = new Rectangle(1.0f, 0.33333334f, 0.0f, -0.33333334f);
    public static final Rectangle uleft090 = new Rectangle(0.6666667f, 0.33333334f, 0.16666667f, -0.33333334f);
    public static final Rectangle uright090 = new Rectangle(0.6666667f, 0.33333334f, 0.16666667f, 0.33333334f);
    public static final Rectangle ubottom090 = new Rectangle(0.33333334f, 1.0f, -0.33333334f, 0.0f);
    public static final Rectangle uright180 = new Rectangle(0.33333334f, 0.6666667f, 0.33333334f, -0.16666667f);
    public static final Rectangle uleft180 = new Rectangle(0.33333334f, 0.6666667f, -0.33333334f, -0.16666667f);
    public static final Rectangle ubottom180 = new Rectangle(1.0f, 0.33333334f, 0.0f, 0.33333334f);
    public static final Rectangle uright270 = new Rectangle(0.6666667f, 0.33333334f, -0.16666667f, -0.33333334f);
    public static final Rectangle uleft270 = new Rectangle(0.6666667f, 0.33333334f, -0.16666667f, 0.33333334f);
    public static final Rectangle ubottom270 = new Rectangle(0.33333334f, 1.0f, 0.33333334f, 0.0f);
    public static final Rectangle stop000 = new Rectangle(1.0f, 0.2f, 0.0f, -0.4f);
    public static final Rectangle smiddle000 = new Rectangle(1.0f, 0.2f, 0.0f, 0.0f);
    public static final Rectangle sbottom000 = new Rectangle(1.0f, 0.2f, 0.0f, 0.4f);
    public static final Rectangle sleft000 = new Rectangle(0.2f, 0.2f, -0.4f, 0.2f);
    public static final Rectangle sright000 = new Rectangle(0.2f, 0.2f, 0.4f, -0.2f);
    public static final Rectangle stop090 = new Rectangle(0.2f, 1.0f, -0.4f, 0.0f);
    public static final Rectangle smiddle090 = new Rectangle(0.2f, 1.0f, 0.0f, 0.0f);
    public static final Rectangle sbottom090 = new Rectangle(0.2f, 1.0f, 0.4f, 0.0f);
    public static final Rectangle sleft090 = new Rectangle(0.2f, 0.2f, -0.2f, 0.4f);
    public static final Rectangle sright090 = new Rectangle(0.2f, 0.2f, 0.2f, -0.4f);

    public Rectangle(float xdim, float zdim, float xcoord, float zcoord) {
        this.xdim = xdim;
        this.zdim = zdim;
        this.xcoord = xcoord;
        this.zcoord = zcoord;
    }

    public void drawLiquid(Dungeon dungeon, Room room, float sx, float sz, float sdimx, float sdimz, boolean invertX, boolean invertZ) {
        byte zend;
        byte zbegin;
        byte xend;
        byte xbegin;
        int drop = dungeon.theme.flags.contains((Object)ThemeFlags.SWAMPY) ? 1 : 2;
        if (invertX) {
            xbegin = (byte)(sx - sdimx * this.xdim / 2.0f - this.xcoord * sdimx);
            xend = (byte)(sx + sdimx * this.xdim / 2.0f - this.xcoord * sdimx);
        } else {
            xbegin = (byte)(sx - sdimx * this.xdim / 2.0f + this.xcoord * sdimx);
            xend = (byte)(sx + sdimx * this.xdim / 2.0f + this.xcoord * sdimx);
        }
        if (invertZ) {
            zbegin = (byte)(sz - sdimz * this.zdim / 2.0f - this.zcoord * sdimz);
            zend = (byte)(sz + sdimz * this.zdim / 2.0f - this.zcoord * sdimz);
        } else {
            zbegin = (byte)(sz - sdimz * this.zdim / 2.0f + this.zcoord * sdimz);
            zend = (byte)(sz + sdimz * this.zdim / 2.0f + this.zcoord * sdimz);
        }
        for (byte k = zbegin; k < zend; k = (byte)(k + 1)) {
            for (byte j = xbegin; j < xend; j = (byte)(j + 1)) {
                byte nFloorY;
                if (j < 0 || j >= dungeon.size.width || k < 0 || k >= dungeon.size.width || dungeon.map.room[j][k] != room.id) continue;
                if (dungeon.map.floorY[j][k] > room.floorY) {
                    dungeon.map.floorY[j][k] = (byte)room.floorY;
                }
                dungeon.map.floorY[j][k] = (byte)(room.floorY - drop);
                dungeon.map.hasLiquid[j][k] = true;
                dungeon.map.nFloorY[j][k] = nFloorY = dungeon.map.nFloorY[j][k] < dungeon.map.floorY[j][k] ? dungeon.map.nFloorY[j][k] : dungeon.map.floorY[j][k];
            }
        }
    }

    public void drawWalkway(Dungeon dungeon, Room room, float sx, float sz, byte sdimx, byte sdimz, boolean invertX, boolean invertZ) {
        byte zend;
        byte zbegin;
        byte xend;
        byte xbegin;
        int drop = dungeon.theme.type.contains((Object)ThemeType.SWAMP) ? 1 : 2;
        if (invertX) {
            xbegin = (byte)(sx - (float)sdimx * this.xdim / 2.0f - this.xcoord * (float)sdimx);
            xend = (byte)(sx + (float)sdimx * this.xdim / 2.0f - this.xcoord * (float)sdimx);
        } else {
            xbegin = (byte)(sx - (float)sdimx * this.xdim / 2.0f + this.xcoord * (float)sdimx);
            xend = (byte)(sx + (float)sdimx * this.xdim / 2.0f + this.xcoord * (float)sdimx);
        }
        if (invertZ) {
            zbegin = (byte)(sz - (float)sdimz * this.zdim / 2.0f - this.zcoord * (float)sdimz);
            zend = (byte)(sz + (float)sdimz * this.zdim / 2.0f - this.zcoord * (float)sdimz);
        } else {
            zbegin = (byte)(sz - (float)sdimz * this.zdim / 2.0f + this.zcoord * (float)sdimz);
            zend = (byte)(sz + (float)sdimz * this.zdim / 2.0f + this.zcoord * (float)sdimz);
        }
        for (byte k = zbegin; k < zend; k = (byte)(k + 1)) {
            for (byte j = xbegin; j < xend; j = (byte)(j + 1)) {
                if (j < 0 || j >= dungeon.size.width || k < 0 || k >= dungeon.size.width) continue;
                byte nFloorY = dungeon.map.nFloorY[j][k] < dungeon.map.floorY[j][k] ? dungeon.map.nFloorY[j][k] : dungeon.map.floorY[j][k];
                byte[] byArray = dungeon.map.floorY[j];
                byte by = k;
                byArray[by] = (byte)(byArray[by] + drop);
                dungeon.map.hasLiquid[j][k] = false;
                dungeon.map.nFloorY[j][k] = nFloorY;
            }
        }
    }

    public void drawCutout(Dungeon dungeon, Room room, float sx, float sz, float sdimx, float sdimz, boolean invertX, boolean invertZ) {
        byte zend;
        byte zbegin;
        byte xend;
        byte xbegin;
        if (invertX) {
            xbegin = (byte)(sx - sdimx * this.xdim / 2.0f - this.xcoord * sdimx);
            xend = (byte)(sx + sdimx * this.xdim / 2.0f - this.xcoord * sdimx);
        } else {
            xbegin = (byte)(sx - sdimx * this.xdim / 2.0f + this.xcoord * sdimx);
            xend = (byte)(sx + sdimx * this.xdim / 2.0f + this.xcoord * sdimx);
        }
        if (invertZ) {
            zbegin = (byte)(sz - sdimz * this.zdim / 2.0f - this.zcoord * sdimz);
            zend = (byte)(sz + sdimz * this.zdim / 2.0f - this.zcoord * sdimz);
        } else {
            zbegin = (byte)(sz - sdimz * this.zdim / 2.0f + this.zcoord * sdimz);
            zend = (byte)(sz + sdimz * this.zdim / 2.0f + this.zcoord * sdimz);
        }
        for (byte k = zbegin; k < zend; k = (byte)(k + 1)) {
            for (byte j = xbegin; j < xend; j = (byte)(j + 1)) {
                if (j < 0 || j >= dungeon.size.width || k < 0 || k >= dungeon.size.width || dungeon.map.room[j][k] != room.id) continue;
                dungeon.map.isWall[j][k] = true;
            }
        }
    }

    public void drawCutin(Dungeon dungeon, Room room, float sx, float sz, byte sdimx, byte sdimz, boolean invertX, boolean invertZ) {
        byte zend;
        byte zbegin;
        byte xend;
        byte xbegin;
        if (invertX) {
            xbegin = (byte)(sx - (float)sdimx * this.xdim / 2.0f - this.xcoord * (float)sdimx);
            xend = (byte)(sx + (float)sdimx * this.xdim / 2.0f - this.xcoord * (float)sdimx);
        } else {
            xbegin = (byte)(sx - (float)sdimx * this.xdim / 2.0f + this.xcoord * (float)sdimx);
            xend = (byte)(sx + (float)sdimx * this.xdim / 2.0f + this.xcoord * (float)sdimx);
        }
        if (invertZ) {
            zbegin = (byte)(sz - (float)sdimz * this.zdim / 2.0f - this.zcoord * (float)sdimz);
            zend = (byte)(sz + (float)sdimz * this.zdim / 2.0f - this.zcoord * (float)sdimz);
        } else {
            zbegin = (byte)(sz - (float)sdimz * this.zdim / 2.0f + this.zcoord * (float)sdimz);
            zend = (byte)(sz + (float)sdimz * this.zdim / 2.0f + this.zcoord * (float)sdimz);
        }
        for (byte k = zbegin; k < zend; k = (byte)(k + 1)) {
            for (byte j = xbegin; j < xend; j = (byte)(j + 1)) {
                if (j < 0 || j >= dungeon.size.width || k < 0 || k >= dungeon.size.width) continue;
                dungeon.map.isWall[j][k] = false;
            }
        }
    }

    public void drawPlatform(Dungeon dungeon, Room room, byte floorY, float sx, float sz, float sdimx, float sdimz, boolean invertX, boolean invertZ) {
        byte zend;
        byte zbegin;
        byte xend;
        byte xbegin;
        if (invertX) {
            xbegin = (byte)(sx - sdimx * this.xdim / 2.0f - this.xcoord * sdimx);
            xend = (byte)(sx + sdimx * this.xdim / 2.0f - this.xcoord * sdimx);
        } else {
            xbegin = (byte)(sx - sdimx * this.xdim / 2.0f + this.xcoord * sdimx);
            xend = (byte)(sx + sdimx * this.xdim / 2.0f + this.xcoord * sdimx);
        }
        if (invertZ) {
            zbegin = (byte)(sz - sdimz * this.zdim / 2.0f - this.zcoord * sdimz);
            zend = (byte)(sz + sdimz * this.zdim / 2.0f - this.zcoord * sdimz);
        } else {
            zbegin = (byte)(sz - sdimz * this.zdim / 2.0f + this.zcoord * sdimz);
            zend = (byte)(sz + sdimz * this.zdim / 2.0f + this.zcoord * sdimz);
        }
        for (byte k = zbegin; k < zend; k = (byte)(k + 1)) {
            for (byte j = xbegin; j < xend; j = (byte)(j + 1)) {
                if (j < 0 || j >= dungeon.size.width || k < 0 || k >= dungeon.size.width || dungeon.map.room[j][k] != room.id) continue;
                dungeon.map.floorY[j][k] = floorY;
                dungeon.map.hasLiquid[j][k] = false;
            }
        }
    }

    public float getxdim() {
        return this.xdim;
    }

    public float getzdim() {
        return this.zdim;
    }

    public float getxcoord() {
        return this.xcoord;
    }

    public float getzcoord() {
        return this.zcoord;
    }
}

